using System;
using System.IO;

public class Exceptions4
{
    public static int Main(string[] args)
    {
        Exceptions4 myExceptionMaker = new Exceptions4();

        try
        {
            myExceptionMaker.GenerateException();
        }
        catch (Exception e)
        {
            Console.WriteLine("\nPrzetwarzanie wyjtku Main():");
            while (e != null)
            {
                Console.WriteLine("\tWyjtek wewntrzny: {0}", e.Message);
                e = e.InnerException;
            }
        }
        finally
        {
            Console.WriteLine("Wywoanie bloku finally z Main()");
        }

        return 0;
    }

    public void GenerateException()
    {
        int mySize = 3;
        byte[] myStream = new byte[mySize];
        int iterations = 5;
        StreamWriter sw = new StreamWriter("exceptions.txt");

        try
        {
            for (byte b=0; b < iterations; b++)
            {
                sw.WriteLine("Byte {0}: {1}", b+1, b);
                myStream[b] = b;
            }
        }
        catch (IndexOutOfRangeException iore)
        {
            Console.WriteLine(
"\nWyjtek 'indeks poza zakresem' w metodzie GenerateException: {0}",
iore.Message);

            throw new Exception(
"Zgoszenie wyjtku z GenerateException.",
iore);
        }
        catch (Exception e)
        {
            Console.WriteLine(
"\nWywoanie wyjtku z GenerateException: {0}", e.Message);
        }
        finally
        {
            Console.WriteLine("Wywoanie bloku finally z GenerateException.");
            sw.WriteLine("Zamykanie pliku");
            sw.Close();
        }
    }
}
